#include <bits/stdc++.h>
using namespace std;

using int64 = long long;

map<int64, int64> naj;

void dfs(int64 prod, int64 num, int lastDigit) {
    if (num > 1e18) return;

    if (!best.count(prod) || best[prod] > num)
        best[prod] = num;

    for (int d = lastDigit; d <= 9; d++) {
        if (d == 0) continue;
        if (prod > (int64)1e18 / d) break;
        dfs(prod * d, num * 10 + d, d);
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    dfs(1, 0, 1);

    vector<int64> minNums;
    for (auto &p : best)
        minNums.push_back(p.second);

    sort(minNums.begin(), minNums.end());

    int T;
    cin >> T;
    while (T--) {
        int64 n;
        cin >> n;

        int ans = upper_bound(minNums.begin(), minNums.end(), n) - minNums.begin();

        if (n >= 10) ans++; 

        cout << ans << "\n";
    }
    return 0;
}